function mcplotpqom(PQoM_Buffer, pqom_parameters) 
% Plots PQoM per frequency band.
%
% syntax
% mcplotpqom(PQoM_Buffer, pqom_parameters);
%
% input parameters
% PQoM_Buffer: buffer containing the PQoM by frequency band 
% pqom_parameters: parameters used to estimated the PQoM 
%
% output
% figure
% 
% example
% see demo_mcpqom.m
% 
% comments
% the inputs parameters are generated by the output of the "mcpqom" function
%
% see also
% mcpqom
%
% ===============================================
% Version 1.0
% July 2015
% ===============================================
% Rodrigo Schramm (rodrigo.schramm@gmail.com)  and   Federico Visi (federico.visi@plymouth.ac.uk)
% UFRGS / Brazil          CMMR / Plymouth University / UK
%
% Part of the Motion Capture Toolbox, Copyright 2008, 
% University of Jyvaskyla, Finland


%%% plot PQoM per band
%===============================================
fWn = pqom_parameters.fWn;
noteType = pqom_parameters.noteType;
bpm = pqom_parameters.bpm;
fs = pqom_parameters.fs;
noteDiv = pqom_parameters.noteDiv;
ws = pqom_parameters.ws;
hs = pqom_parameters.hs;
markerName = pqom_parameters.markerName;
%===============================================

color='rgbkmrgbkmrgbkmrgbkmrgbkmrgbkm';
if length(markerName)==1    
    str = ['Anchor: origin => Markers: ', markerName{:}];     
else
    str = ['Anchor: ',markerName{1}, ' => Markers: '];
    for n=2:length(markerName)
        str = [str, ' ', markerName{n},',']; 
    end
    str = str(1:end-1);
end

figure('Name','Periodic Quantity of Motion','NumberTitle','on'); hold on;
for k=1:size(PQoM_Buffer,2);
    plot(PQoM_Buffer(:,k), color(k));
end
ax = gca;
set(ax,'XTick',1:size(PQoM_Buffer,1));
set(ax,'XTickLabel', [1:size(PQoM_Buffer,1)]*(hs/fs));
xlabel('time position (seconds)');
ylabel('PQoM');
set(ax,'XTick',1:size(PQoM_Buffer,1)/10:size(PQoM_Buffer,1));
%set(ax,'XTickLabel', [0:size(buffer,1)]*(hs/fs));
set(ax,'XTickLabel', [0:size(PQoM_Buffer,1)/10:size(PQoM_Buffer,1)]*(hs/fs));
xlabel(['time position (seconds)  bpm=', num2str(bpm)]);
a = axis; a(1) = 0; a(2) = size(PQoM_Buffer,1);
axis(a);
title(str, 'interpreter', 'none');
legend( noteType);
%===============================================
%%% color map per band
figure('Name','Periodic Quantity of Motion','NumberTitle','on'); hold on;
imagesc(PQoM_Buffer');
ax = gca;
set(ax,'YTick',1:size(PQoM_Buffer,2));
set(ax,'YTickLabel',noteType);

ylabel('freq band (note division)');
set(ax,'XTick',1:size(PQoM_Buffer,1)/10:size(PQoM_Buffer,1));
%set(ax,'XTickLabel', [0:size(buffer,1)]*(hs/fs));
set(ax,'XTickLabel', [0:size(PQoM_Buffer,1)/10:size(PQoM_Buffer,1)]*(hs/fs));
xlabel(['time position (seconds)  bpm=', num2str(bpm)]);
a = axis; a(1) = 0; a(2) = size(PQoM_Buffer,1);
axis(a);
colorbar;
title(str, 'interpreter', 'none');

end
